﻿using System;

namespace VBECS.Services.Common.AppServices
{
    /// <summary>
    /// This is the base class for the service processes.
    /// It provides common access to the logger and initializes configuration.
    /// </summary>
    public abstract class ServerProcessBase : IServerProcess
    {

// These properties are assigned by Spring.NET
// ReSharper disable UnusedAutoPropertyAccessor.Local
        public IEventProcessor EventProcessor { get; internal set; }
        public string Name{ get; internal set; }
// ReSharper restore UnusedAutoPropertyAccessor.Local

        public void Start()
        {
            // Start server process
            do_start();
        }

        abstract protected void do_start();

        // Perform any object clean up here.
        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        #region Disposing

        virtual protected void Dispose(bool disposing)
        {
            // There is nothing to dispose in this class.
        }

        ~ServerProcessBase()
        {
            Dispose(false);
        }
        
        #endregion
    }
}
